<?php
// Load Dolibarr environment
require '../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
llxHeader();

// Récupération de la valeur de socid si elle est passée en GET
$socid = GETPOST('socid', 'int');

// Form to select company and go to remx.php
echo '<form method="GET" action="#" id="mainForm">';
echo '<label for="socid">'.$langs->trans("Selectionner un Client").'</label>';
echo '<select name="socid" id="socid" required>';
echo '<option value="">'.$langs->trans("SelectClient").'</option>';

$sql = "SELECT rowid, nom FROM ".MAIN_DB_PREFIX."societe WHERE entity = ".$conf->entity;
$resql = $db->query($sql);
if ($resql) {
    while ($obj = $db->fetch_object($resql)) {
        $selected = ($obj->rowid == $socid) ? ' selected' : '';
        echo '<option value="'.$obj->rowid.'"'.$selected.'>'.$obj->nom.'</option>';
    }
}
echo '</select>';
echo '</form>';

// Form to go to remx.php
echo '<form method="GET" action="#" onsubmit="afficherResultat(event, \'../comm/remx.php\')">';
echo '<input type="hidden" name="socid" id="remxSocid">';
echo '<input type="submit" value="'.$langs->trans("Les Remises et les Reductions").'">';
echo '</form>';

// Form to go to recap-compta.php
echo '<form method="GET" action="#" onsubmit="afficherResultat(event, \'../compta/recap-compta.php\')">';
echo '<input type="hidden" name="socid" id="recapSocid">';
echo '<input type="submit" value="'.$langs->trans("La Recap Montant Encours").'">';
echo '</form>';

// Form to go to card.php
echo '<form method="GET" action="#" onsubmit="afficherResultat(event, \'../comm/card.php\')">';
echo '<input type="hidden" name="socid" id="detailSocid">';
echo '<input type="submit" value="'.$langs->trans("Details Clients").'">';
echo '</form>';

// Form to go to Paiment.php
echo '<form method="GET" action="#" onsubmit="afficherResultat(event, \'../compta/paiement/cardClient.php\')">';
echo '<input type="hidden" name="socid" id="paimentSocid">';
echo '<input type="submit" value="'.$langs->trans("Paiments Clients").'">';
echo '</form>';

echo '<div id="resultat" class="resultat"></div>';
?>

<script type="text/javascript">
// Script pour synchroniser la sélection de socid entre les formulaires
document.getElementById('socid').addEventListener('change', function() {
    var socid = this.value;
    document.getElementById('remxSocid').value = socid;
    document.getElementById('recapSocid').value = socid;
    document.getElementById('detailSocid').value = socid;
    document.getElementById('paimentSocid').value = socid;
});

function afficherResultat(event, actionUrl) {
    event.preventDefault();
    var socid = document.getElementById('socid').value;
    if (!socid) {
        alert("Veuillez sélectionner un client.");
        return;
    }

    var xhr = new XMLHttpRequest();
    xhr.open("GET", actionUrl + "?socid=" + socid, true);
    xhr.onload = function() {
        if (xhr.status === 200) {
            document.getElementById('resultat').innerHTML = xhr.responseText;
        } else {
            alert("Une erreur est survenue lors de la récupération des données.");
        }
    };
    xhr.send();
}
</script>

<?php
// End of page
llxFooter();
$db->close();
?>
