<?php

if (!defined('NOTOKENRENEWAL'))  define('NOTOKENRENEWAL', 1);
if (!defined('NOCSRFCHECK'))     define('NOCSRFCHECK', 1);

$res=0;

if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";

dol_include_once('/pointagerh/lib/pointagerh.lib.php');
dol_include_once('/pointagerh/class/pointagerh.class.php');

$pointagerh  = new pointagerh($db);

// Translations
$langs->load("pointagerh@pointagerh");
$langs->load("admin");

// Access control
if (! $user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');
$show_leftmenu = GETPOST('show_leftmenu');

if ($action == 'save') {
    $nbd_month = GETPOST ( 'nbd_month', 'text' );
    $nbh_day = GETPOST ( 'nbh_day', 'int' );

    $error = 0;
    if ($nbh_day){
        $res = dolibarr_set_const($db, 'POINTAGERH_NBHBYDAY', $nbh_day, 'int', 0, '', $conf->entity);
    }
    if ($nbd_month){
        $res = dolibarr_set_const($db, 'POINTAGERH_NBDBYMONTH', $nbd_month, 'int', 0, '', $conf->entity);
    }

    if (! $res > 0) $error ++;


    if (! $error) {
        activateModule('modCron');
        setEventMessage($langs->trans("SetupSaved"), 'mesgs');
    } else {
        setEventMessage($langs->trans("Error"), 'errors');
    }
}
elseif ($action == 'setinterventionemail_beforeafter') {
    $name = GETPOST ( 'name', 'text' ); $value = GETPOST ( 'value', 'int' );

    $error = 0;
    if ($value){
        $res = dolibarr_set_const($db, $name, 1, 'chaine', 0, '', 0);
    }else{
        $res = dolibarr_set_const($db, $name, 0, 'chaine', 0, '', 0);
    }
    if (! $res > 0) $error ++;

    if (! $error) {
        // activateModule('modCron');
        setEventMessage($langs->trans("SetupSaved"), 'mesgs');
    } else {
        setEventMessage($langs->trans("Error"), 'errors');
    }
}
elseif ($action == 'pointagerh_interventionmails') {
    $name = GETPOST ( 'name', 'text' );
    $nbrd = GETPOST ( 'pointagerh_INTERVENTION_EMAIL_DAYS_BEFORE', 'int' );
    $msgcont = GETPOST ( 'pointagerh_INTERVENTION_EMAIL_CONTENT_MSG', 'int' );

    $error = 0;
    if ($nbrd && $nbrd > 0){
        $res = dolibarr_set_const($db, $name, $nbrd, 'chaine', 0, '', 0);
        
        // $sql = "UPDATE " . MAIN_DB_PREFIX. "cronjob SET frequency = '".$nbrd."', unitfrequency = 86400 WHERE module_name = 'pointagerh' AND classesname = 'pointagerh/class/pointagerh_interventions.class.php' AND objectname = 'interventions_parc' AND methodename = 'checkInterventionsMails'";
        // $resql = $db->query($sql);
        // if($resql) $res = dolibarr_set_const($db, $name, $nbrd, 'chaine', 0, '', 0);

    }

    // if(!empty($msgcont)){
        
    // }
    
    if (! $res > 0) $error ++;


    if (! $error) {
        setEventMessage($langs->trans("SetupSaved"), 'mesgs');
    } else {
        setEventMessage($langs->trans("Error"), 'errors');
    }
}
elseif($action == 'set_show_leftmenu'){
    if(!dolibarr_set_const($db, "POINTAGERH_SHOW_LEFTMENU", $show_leftmenu, 'chaine', 0, '', $conf->entity)) {
        $error++;
    }
}

if(!empty($action)){
    header('Location: ./admin.php');
    exit;
}



/*
 * View
 */
$page_name = "pointagerhSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// // Configuration header
$head = pointagerhAdminPrepareHead();
dol_fiche_head($head, 'setting', $langs->trans("Configuration"), -1, "cog");


$nbh_day = $conf->global->POINTAGERH_NBHBYDAY ? $conf->global->POINTAGERH_NBHBYDAY : 9;
$nbd_month = $conf->global->POINTAGERH_NBDBYMONTH ? $conf->global->POINTAGERH_NBDBYMONTH : 26;

print '<div class="pointagerh_admin">';

print '<form id="col4-form" method="post" action="'.$_SERVER["PHP_SELF"].'">';
    print '<input type="hidden" name="action" value="save">';
    print '<table class="noborder" width="100%">';
        print '<tr class="liste_titre">';
            print '<td class="width20p">'.$langs->trans("Parameter").'</td>';
            print '<td>'.$langs->trans("Value").'</td>';
        print '</tr>';

        print '<tr>';
            print '<td class="">'.$langs->trans('POINTAGERH_NBHBYDAY').'</td>';
            print '<td><input class="maxwidth50" name="nbh_day" type="number" value="'.$nbh_day.'"> '.$langs->trans('Hours').'</td>';
        print '</tr>';

        // print '<tr>';
        //     print '<td>'.$langs->trans('POINTAGERH_NBDBYMONTH').'</td>';
        //     print '<td><input class="maxwidth50" name="nbd_month" type="number" value="'.$nbd_month.'"> '.$langs->trans('Days').'</td>';
        // print '</tr>';

        print '<tr>';
            print '<td class="titlefield nowraponall">'.$langs->trans('show_leftmenu').'&nbsp;&nbsp;</td>';
            print '<td>';
                if ($conf->global->POINTAGERH_SHOW_LEFTMENU) {
                    print '<a class="reposition" href="'.$_SERVER['PHP_SELF'].'?action=set_show_leftmenu&show_leftmenu=0">';
                    print img_picto($langs->trans("Activated"), 'switch_on');
                    print '</a>';
                } else {
                    print '<a class="reposition" href="'.$_SERVER['PHP_SELF'].'?action=set_show_leftmenu&show_leftmenu=1">';
                    print img_picto($langs->trans("Disabled"), 'switch_off');
                    print '</a>';
                }
                // print $form->selectyesno('t_colortaskbyuser', $t_colortaskbyuser, 0, false, 1);
            print '</td>';
        print '</tr>';

    print '</table>';

    print '<br>';
    
    // Actions
    print '<table class="" width="100%">';
    print '<tr>';
        print '<td colspan="2" align="left">';
        print '<input type="submit" value="'.$langs->trans('Validate').'" name="bouton" class="button" />';
        print '</td>';
    print '</tr>';
    print '</table>';
print '</form>';




print '</div>';

llxFooter();

$db->close();