<?php 
require_once DOL_DOCUMENT_ROOT. '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT. '/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT. '/product/stock/class/mouvementstock.class.php';

require_once DOL_DOCUMENT_ROOT. "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT. '/core/class/CMailFile.class.php';

class pointagerh extends Commonobject{ 

	public $errors = array();
	public $id;
	public $rowid;
	public $date;
	public $fk_user;
	public $jour;
	public $nbhr;
	public $status;

	public $element='pointagerh';
	public $table_element='pointagerh';
	

	public function __construct($db){ 
		global $langs;

		$this->db = $db;


		return 1;
    }
   	
	public function Initpointagerh()
	{
		global $conf, $langs;

		$langs->load('pointagerh@pointagerh');

		$nbh_day = $conf->global->POINTAGERH_NBHBYDAY ? $conf->global->POINTAGERH_NBHBYDAY : 9;
        dolibarr_set_const($this->db, 'POINTAGERH_NBHBYDAY', $nbh_day, 'int', 0, '', $conf->entity);

		$nbd_month = $conf->global->POINTAGERH_NBDBYMONTH ? $conf->global->POINTAGERH_NBDBYMONTH : 26;
        dolibarr_set_const($this->db, 'POINTAGERH_NBDBYMONTH', $nbd_month, 'int', 0, '', $conf->entity);

        if($conf->global->POINTAGERH_SHOW_LEFTMENU == '')
        	dolibarr_set_const($this->db, 'POINTAGERH_SHOW_LEFTMENU', 0, 'int', 0, '', $conf->entity);

		$sql = "CREATE TABLE IF NOT EXISTS ".MAIN_DB_PREFIX."pointagerh_pointage (
		  	rowid int NOT NULL AUTO_INCREMENT PRIMARY KEY
            ,fk_chantier int NULL
		  	,fk_user int NULL
            ,datep date NULL
		  	,jour DECIMAL(24,2) NULL
		  	,nbhr DECIMAL(24,2) NULL
		  	,entity int NOT NULL DEFAULT ".$conf->entity."
		);";
		$resql = $this->db->query($sql);
		$resql = $this->db->query('ALTER TABLE '.MAIN_DB_PREFIX.'pointagerh_pointage CHANGE jour jour DECIMAL(24,2) NULL;');
		$resql = $this->db->query('ALTER TABLE '.MAIN_DB_PREFIX.'pointagerh_pointage CHANGE nbhr nbhr DECIMAL(24,2) NULL;');
        $resql = $this->db->query("ALTER TABLE ".MAIN_DB_PREFIX."pointagerh_pointage ADD UNIQUE INDEX uk_fk_user_datep (fk_user, datep);");

		$sql = "CREATE TABLE IF NOT EXISTS ".MAIN_DB_PREFIX."pointagerh_datamonth (
            rowid int NOT NULL AUTO_INCREMENT PRIMARY KEY
            ,fk_chantier int NULL
            ,fk_user int DEFAULT NULL
            ,tjm DECIMAL(24, 2) NULL
            ,month int DEFAULT NULL
            ,year int DEFAULT NULL
        );";
        $resql = $this->db->query($sql);
        $resql = $this->db->query("ALTER TABLE ".MAIN_DB_PREFIX."pointagerh_datamonth ADD UNIQUE INDEX uk_fk_chantier_fk_user_month_year (fk_chantier, fk_user, month, year);");

		$position = 1;

		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
        $extrafields = new ExtraFields($this->db);

        $tmparr = array(
			'month' => $langs->trans('pointagerhByMonth'),
			'qz' 	=> $langs->trans('pointagerhByQZ')
		);

		$params = serialize(array('options' => $tmparr));
        $exres = $extrafields->addExtraField('pointagerh_pointagetype', 'pointagerh_pointagetype', "select", $position++, 100, "user", 0, 0, 'month', $params, 0, '', 1);
        // d($exres);

	}


    public function getLastInsertedChantier()
    {
    	$sql = "SELECT o.rowid FROM ".MAIN_DB_PREFIX."parcmateriel_chantier as o order by rowid ASC limit 1";
		$resql = $this->db->query($sql);

		$chantier_id = 0;
		if ($resql)
        {
            $num = $this->db->num_rows($resql);
          
            while ($obj = $this->db->fetch_object($resql))
            {	
                $chantier_id = $obj->rowid;
            }
        }

        return $chantier_id;
	}


    public function pointagerhSelectJobUsers($selected = '', $name = 'srch_job', $showempty = 1, $moreclass="minwidth200 maxwidth400", $srch_group = 0, $mode = 'month')
    {
        global $langs, $conf;

        $namesql = 'job';

        $sql = "SELECT DISTINCT u.job FROM ".MAIN_DB_PREFIX."user as u";
        $sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user_extrafields as exu ON (u.rowid = exu.fk_object)';
        $sql .= " WHERE u.entity = ".(int)$conf->entity;

        if($srch_group > 0) {
        	$sql .= " AND u.rowid IN (SELECT fk_user FROM ".MAIN_DB_PREFIX."usergroup_user WHERE fk_usergroup = ".(int)$srch_group." )";
        }

        if($mode) {
			$sql .= ' AND exu.pointagerh_pointagetype = "'.$mode.'"';
		}

        print '<select id="'.$name.'" class="flat maxwidthonsmartphone '.$moreclass.'" name="'.$name.'">';

            if($showempty) {
                print '<option value="0">&nbsp;</option>';
            }

            $resql = $this->db->query($sql);

            if ($resql)
            {
                $num = $this->db->num_rows($resql);
                $i = 0;
                if ($num)
                {
                    while ($i < $num)
                    {
                        $obj = $this->db->fetch_object($resql);
                        if($obj->$namesql){
                            $selectstring = '';
                            if ($selected != '' && $selected == $obj->$namesql) $selectstring = ' selected';

                            print '<option value="'.$obj->$namesql.'"'.$selectstring.'>'.$obj->$namesql.'</option>';
                        }
                        $i++;
                    }
                }
            }

        print '</select>';
    }



    public function pointagerh_select_chantier($selected=0, $htmlname='', $showempty = 1, $moreparam='', $moreclass="width100 maxwidth200")
	{
		global $langs, $conf;

		$sql = "SELECT obj.rowid, obj.label";
		$sql .= " FROM ".MAIN_DB_PREFIX."parcmateriel_chantier as obj";
		$sql .= " WHERE obj.entity = ".$conf->entity;

		$sql .= " ORDER BY obj.rowid DESC";

		$resql = $this->db->query($sql);

		$html = '';

		if ($resql)
		{
			$html .= '<select class="flat maxwidthonsmartphone select_chantier fk_chantier '.$moreclass.' " id="'.$htmlname.'" name="'.$htmlname.'" '.$moreparam.'>';
			$num = $this->db->num_rows($resql);

			$i = 0;
			if ($num)
			{
				if($showempty)
				$html .= '<option value="-1">&nbsp;</option>';
				while ($i < $num)
				{
					$obj = $this->db->fetch_object($resql);
					
					$selectstring = '';
					if ($selected > 0 && $selected == $obj->rowid) $selectstring = ' selected';

					$disabled = '';
					$html .= '<option value="'.$obj->rowid.'"'.$selectstring.$disabled.'>'.$obj->label.'</option>';
					$i++;
				}
			}
			$html .= '</select>';

			return $html;

		} else {
			dol_print_error($this->db);
			return -1;
		}
	}

    public function pointagerh_select_dolusers($selected = '', $htmlname = 'userid', $show_empty = 0, $exclude = null, $disabled = 0, $include = '', $enableonly = '', $force_entity = '0', $maxlength = 0, $showstatus = 0, $morefilter = '', $show_every = 0, $enableonlytext = '', $morecss = '', $noactive = 0, $outputmode = 0, $multiple = false, $forcecombo = 0)
	{
		// phpcs:enable
		global $conf, $user, $langs, $hookmanager;
		global $action;

		// If no preselected user defined, we take current user
		if ((is_numeric($selected) && ($selected < -2 || empty($selected))) && empty($conf->global->SOCIETE_DISABLE_DEFAULT_SALESREPRESENTATIVE)) {
			$selected = $user->id;
		}

		if ($selected === '') {
			$selected = array();
		} elseif (!is_array($selected)) {
			$selected = array($selected);
		}

		$excludeUsers = null;
		$includeUsers = null;

		// Permettre l'exclusion d'utilisateurs
		if (is_array($exclude)) {
			$excludeUsers = implode(",", $exclude);
		}
		// Permettre l'inclusion d'utilisateurs
		if (is_array($include)) {
			$includeUsers = implode(",", $include);
		} elseif ($include == 'hierarchy') {
			// Build list includeUsers to have only hierarchy
			$includeUsers = implode(",", $user->getAllChildIds(0));
		} elseif ($include == 'hierarchyme') {
			// Build list includeUsers to have only hierarchy and current user
			$includeUsers = implode(",", $user->getAllChildIds(1));
		}

		$out = '';
		$outarray = array();

		// Forge request to select users
		$sql = "SELECT DISTINCT u.rowid, u.lastname as lastname, u.firstname, u.statut as status, u.login, u.admin, u.entity, u.photo";
		if (!empty($conf->multicompany->enabled) && $conf->entity == 1 && $user->admin && !$user->entity) {
			$sql .= ", e.label";
		}
		$sql .= " FROM ".$this->db->prefix()."user as u";
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user_extrafields as exu ON (u.rowid = exu.fk_object)';
		if (!empty($conf->multicompany->enabled) && $conf->entity == 1 && $user->admin && !$user->entity) {
			$sql .= " LEFT JOIN ".$this->db->prefix()."entity as e ON e.rowid = u.entity";
			if ($force_entity) {
				$sql .= " WHERE u.entity IN (0, ".$this->db->sanitize($force_entity).")";
			} else {
				$sql .= " WHERE u.entity IS NOT NULL";
			}
		} else {
			if (!empty($conf->multicompany->enabled) && !empty($conf->global->MULTICOMPANY_TRANSVERSE_MODE)) {
				$sql .= " LEFT JOIN ".$this->db->prefix()."usergroup_user as ug";
				$sql .= " ON ug.fk_user = u.rowid";
				$sql .= " WHERE ug.entity = ".$conf->entity;
			} else {
				$sql .= " WHERE u.entity IN (0, ".$conf->entity.")";
			}
		}
		if (!empty($user->socid)) {
			$sql .= " AND u.fk_soc = ".((int) $user->socid);
		}
		if (is_array($exclude) && $excludeUsers) {
			$sql .= " AND u.rowid NOT IN (".$this->db->sanitize($excludeUsers).")";
		}
		if ($includeUsers) {
			$sql .= " AND u.rowid IN (".$this->db->sanitize($includeUsers).")";
		}
		if (!empty($conf->global->USER_HIDE_INACTIVE_IN_COMBOBOX) || $noactive) {
			$sql .= " AND u.statut <> 0";
		}
		if (!empty($morefilter)) {
			$sql .= " ".$morefilter;
		}

		//Add hook to filter on user (for exemple on usergroup define in custom modules)
		$reshook = $hookmanager->executeHooks('addSQLWhereFilterOnSelectUsers', array(), $this, $action);
		if (!empty($reshook)) {
			$sql .= $hookmanager->resPrint;
		}

		if (empty($conf->global->MAIN_FIRSTNAME_NAME_POSITION)) {	// MAIN_FIRSTNAME_NAME_POSITION is 0 means firstname+lastname
			$sql .= " ORDER BY u.statut DESC, u.firstname ASC, u.lastname ASC";
		} else {
			$sql .= " ORDER BY u.statut DESC, u.lastname ASC, u.firstname ASC";
		}

		dol_syslog(get_class($this)."::select_dolusers", LOG_DEBUG);

		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			$i = 0;
			if ($num) {
				// do not use maxwidthonsmartphone by default. Set it by caller so auto size to 100% will work when not defined
				$out .= '<select class="flat'.($morecss ? ' '.$morecss : ' minwidth200').'" id="'.$htmlname.'" name="'.$htmlname.($multiple ? '[]' : '').'" '.($multiple ? 'multiple' : '').' '.($disabled ? ' disabled' : '').'>';
				if ($show_empty && !$multiple) {
					$textforempty = ' ';
					if (!empty($conf->use_javascript_ajax)) {
						$textforempty = '&nbsp;'; // If we use ajaxcombo, we need &nbsp; here to avoid to have an empty element that is too small.
					}
					if (!is_numeric($show_empty)) {
						$textforempty = $show_empty;
					}
					$out .= '<option class="optiongrey" value="'.($show_empty < 0 ? $show_empty : -1).'"'.((empty($selected) || in_array(-1, $selected)) ? ' selected' : '').'>'.$textforempty.'</option>'."\n";
				}
				if ($show_every) {
					$out .= '<option value="-2"'.((in_array(-2, $selected)) ? ' selected' : '').'>-- '.$langs->trans("Everybody").' --</option>'."\n";
				}

				$userstatic = new User($this->db);

				while ($i < $num) {
					$obj = $this->db->fetch_object($resql);

					$userstatic->id = $obj->rowid;
					$userstatic->lastname = $obj->lastname;
					$userstatic->firstname = $obj->firstname;
					$userstatic->photo = $obj->photo;
					$userstatic->statut = $obj->status;
					$userstatic->entity = $obj->entity;
					$userstatic->admin = $obj->admin;

					$disableline = '';
					if (is_array($enableonly) && count($enableonly) && !in_array($obj->rowid, $enableonly)) {
						$disableline = ($enableonlytext ? $enableonlytext : '1');
					}

					$labeltoshow = '';

					// $fullNameMode is 0=Lastname+Firstname (MAIN_FIRSTNAME_NAME_POSITION=1), 1=Firstname+Lastname (MAIN_FIRSTNAME_NAME_POSITION=0)
					$fullNameMode = 0;
					if (empty($conf->global->MAIN_FIRSTNAME_NAME_POSITION)) {
						$fullNameMode = 1; //Firstname+lastname
					}
					$labeltoshow .= $userstatic->getFullName($langs, $fullNameMode, -1, $maxlength);
					if (empty($obj->firstname) && empty($obj->lastname)) {
						$labeltoshow .= $obj->login;
					}

					// Complete name with more info
					$moreinfo = '';
					if (!empty($conf->global->MAIN_SHOW_LOGIN)) {
						$moreinfo .= ($moreinfo ? ' - ' : ' (').$obj->login;
					}
					if ($showstatus >= 0) {
						if ($obj->status == 1 && $showstatus == 1) {
							$moreinfo .= ($moreinfo ? ' - ' : ' (').$langs->trans('Enabled');
						}
						if ($obj->status == 0 && $showstatus == 1) {
							$moreinfo .= ($moreinfo ? ' - ' : ' (').$langs->trans('Disabled');
						}
					}
					if (!empty($conf->multicompany->enabled) && empty($conf->global->MULTICOMPANY_TRANSVERSE_MODE) && $conf->entity == 1 && $user->admin && !$user->entity) {
						if (!$obj->entity) {
							$moreinfo .= ($moreinfo ? ' - ' : ' (').$langs->trans("AllEntities");
						} else {
							if ($obj->entity != $conf->entity) {
								$moreinfo .= ($moreinfo ? ' - ' : ' (').($obj->label ? $obj->label : $langs->trans("EntityNameNotDefined"));
							}
						}
					}
					$moreinfo .= ($moreinfo ? ')' : '');
					if ($disableline && $disableline != '1') {
						$moreinfo .= ' - '.$disableline; // This is text from $enableonlytext parameter
					}
					$labeltoshow .= $moreinfo;

					$out .= '<option value="'.$obj->rowid.'"';
					if ($disableline) {
						$out .= ' disabled';
					}
					if ((is_object($selected) && $selected->id == $obj->rowid) || (!is_object($selected) && in_array($obj->rowid, $selected))) {
						$out .= ' selected';
					}
					$out .= ' data-html="';
					$outhtml = '';
					// if (!empty($obj->photo)) {
					$outhtml .= $userstatic->getNomUrl(-3, '', 0, 1, 24, 1, 'login', '', 1).' ';
					// }
					if ($showstatus >= 0 && $obj->status == 0) {
						$outhtml .= '<strike class="opacitymediumxxx">';
					}
					$outhtml .= $labeltoshow;
					if ($showstatus >= 0 && $obj->status == 0) {
						$outhtml .= '</strike>';
					}
					$out .= dol_escape_htmltag($outhtml);
					$out .= '">';
					$out .= $labeltoshow;
					$out .= '</option>';

					$outarray[$userstatic->id] = $userstatic->getFullName($langs, $fullNameMode, -1, $maxlength).$moreinfo;

					$i++;
				}
			} else {
				$out .= '<select class="flat" id="'.$htmlname.'" name="'.$htmlname.'" disabled>';
				$out .= '<option value="">'.$langs->trans("None").'</option>';
			}
			$out .= '</select>';

			if ($num && !$forcecombo) {
				// Enhance with select2
				include_once DOL_DOCUMENT_ROOT.'/core/lib/ajax.lib.php';
				$out .= ajax_combobox($htmlname);
			}
		} else {
			dol_print_error($this->db);
		}

		if ($outputmode) {
			return $outarray;
		}

		return $out;
	}

} 
	

	
?>