<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT .'/product/stock/class/mouvementstock.class.php';

require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';

class pointagerh_pointage extends Commonobject{ 

	public $errors = array();
	public $id;
	public $rowid;
	public $datep;
	public $fk_user;
	public $jour;
	public $nbhr;
	public $status;

	public $element='pointagerh_pointage';
	public $table_element='pointagerh_pointage';

	public $picto='projecttask';
	
	/**
	 * Intervention en Attent
	 */
	const STATUT_EN_ATTENT = 0;

	/**
	 * Intervention traite
	 */
	const STATUT_TRAITE = 1;


	public function __construct($db){ 
		global $langs;

		$this->db = $db;

		$this->labelstatus =array(self::STATUT_EN_ATTENT => $langs->trans('OnHold'), self::STATUT_TRAITE => $langs->trans('intervTraite'));
		
		return 1;
    }
   
   
	public function create($echo_sql=0)
	{
		global $conf;
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		$sql.= "fk_user, jour, nbhr, datep, entity )";

		$sql.= " VALUES (";
		$sql.= " ".($this->fk_user>0?$this->fk_user:"null");
		$sql.= ", ".$this->jour;
		$sql.= ", ".($this->nbhr>0?$this->nbhr:"null");
        $sql.= ", ".($this->datep != '' ? "'".$this->db->idate($this->datep)."' " : 'null');
        $sql.= ", ".$this->db->escape($conf->entity)." ";
		$sql.= ")";

		// die($sql);
		$resql = $this->db->query($sql);
		if ($resql) {
			$this->id=$this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);
			return $this->id;
		}
		else {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
	}

	public function update($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = "UPDATE " . MAIN_DB_PREFIX .get_class($this). " SET ";

		$sql .= " fk_user = ".($this->fk_user>0?$this->db->escape($this->fk_user):"null");
		$sql .= ", datep = ".($this->datep ? "'".$this->db->idate($this->datep)."'" :"null");
		$sql .= ", jour = ".$this->jour;
		$sql .= ", nbhr = ".($this->nbhr>0?$this->db->escape($this->nbhr):"null");
		$sql .= ", entity = ".$this->entity." ";

        $sql .= " WHERE rowid = " . $id;
        $resql = $this->db->query($sql);
        if ($resql) {
			$result=$this->insertExtraFields();
		}
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			// print_r($this->errors);
			// die();
			return -1;
			
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
        if ($resql)
        {
	        // $sql = "DELETE FROM ".MAIN_DB_PREFIX.$this->table_element."_extrafields";
	        // $sql .= " WHERE fk_object=".$this->id;

	        // $resql = $this->db->query($sql);
	        // if (!$resql)
	        // {
	        // 	$this->errors[] = $this->db->lasterror();
	        // 	$error++;
	        // }
        }
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			print_r($this->errors);die();
			return -1;
		} 


		return 1;
	}

	public function fetch($id)
	{
		global $conf;
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$sql .= ' AND entity='.$conf->entity;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			  	     = $this->db->fetch_object($resql);
                $this->id         	     = $obj->rowid;
                $this->rowid      	  	 = $obj->rowid;
              	$this->fk_user 	=  $obj->fk_user;
				$this->datep 	=  $this->db->jdate($obj->datep);
				$this->jour 	=  $obj->jour;
				$this->nbhr 	=  $obj->nbhr;

				$this->entity            = $obj->entity;
				$this->fetch_optionals();
               	
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}


    public function getLibStatut($mode)
	{
		return $this->LibStatut($this->status, $mode);
	}

	public function LibStatut($status, $mode, $donotshowbilled = 0)
	{
		// phpcs:enable
		global $langs, $conf;

		$labelTooltip = '';

		// if ($status == self::STATUT_EN_ATTENT) {
		// 	$labelStatus = $langs->transnoentitiesnoconv('OnHold');
		// 	$labelStatusShort = $labelStatus;
		// 	$statusType = 'status0';
		// } elseif ($status == self::STATUT_TRAITE) {
		// 	$labelStatus = $langs->transnoentitiesnoconv('intervTraite');
		// 	$labelStatusShort = $labelStatus;
		// 	$statusType = 'status4';
		// }

		// return dolGetStatus($labelStatus, $labelStatusShort, '', $statusType, $mode, '', array('tooltip' => $labelTooltip));
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
        if(!empty($this->ref)){
        	$ref=$this->ref;
        }else
        	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/postes/img/object_postes.png" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function dataPointage($month, $year, $fk_chantier='', $fk_user='', $srch_job='', $srch_group=0)
    {	
    	global $parcmaterielenabled;

    	$data = array();

		$sql = 'SELECT o.rowid, o.fk_user, o.fk_chantier, o.datep, o.jour, o.nbhr, DAY(o.datep) as day, MONTH(o.datep) as month';
		$sql .= ', ch.label as label_chantier ';
		$sql .= ' FROM '.MAIN_DB_PREFIX.'pointagerh_pointage as o ';

		if($parcmaterielenabled)
			$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'parcmateriel_chantier as ch ON (ch.rowid = o.fk_chantier)';
		
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user as u ON o.fk_user = u.rowid';

		$sql .= ' WHERE 1';

		if($month > 0) {
			$sql .= ' AND MONTH(o.datep)='.$month;
		}
		
		$sql .= ' AND YEAR(o.datep)='.$year;

		$sql .= $fk_user>0 ? ' AND o.fk_user='.$fk_user : '';
		$sql .= !empty($srch_job) ? " AND u.job = '".$srch_job."'" : "";
		// $sql .= $fk_chantier>0 ? ' AND o.fk_chantier='.$fk_chantier : '';

		$sql .= " AND u.employee = 1";

		if($srch_group > 0) {
			$sql .= " AND u.rowid IN (SELECT fk_user FROM ".MAIN_DB_PREFIX."usergroup_user WHERE fk_usergroup = ".(int)$srch_group." )";
		}

		$sql .= " ORDER BY o.datep ASC";
		// echo $sql;

    	$resql = $this->db->query($sql);
    	if($resql){
    		while ($obj = $this->db->fetch_object($resql)) {
    			// $date = $this->db->jdate($obj->datep);

    			// if($month > 0) {
	    			$data[$obj->fk_user][$obj->day]['id']=$obj->rowid;
	    			$data[$obj->fk_user][$obj->day]['fk_chantier']=$obj->fk_chantier;
	    			$data[$obj->fk_user][$obj->day]['date']=$obj->datep;
	    			$data[$obj->fk_user][$obj->day]['jour']=$obj->jour;
	    			$data[$obj->fk_user][$obj->day]['nbhr']=$obj->nbhr;
	    			$data[$obj->fk_user][$obj->day]['label_chantier']=$obj->label_chantier;
    			// } else {
	    		// 	$data[$obj->month][$obj->fk_user][$obj->day]['date']=$obj->datep;
	    		// 	$data[$obj->month][$obj->fk_user][$obj->day]['id']=$obj->rowid;
	    		// 	$data[$obj->month][$obj->fk_user][$obj->day]['jour']=$obj->jour;
	    		// 	$data[$obj->month][$obj->fk_user][$obj->day]['nbhr']=$obj->nbhr;
    			// }

    		}
    	}
    	return $data;
    }




    // public function pointagerh_datamonth($month, $year, $qz, $fk_user = '', $srch_job = '', $srch_group = 0)
    // {	
    // 	$data = array();

	// 	$sql = 'SELECT o.*, u.tjm as user_tjm';
	// 	$sql .= ' FROM '.MAIN_DB_PREFIX.'pointagerh_datamonth as o ';
	// 	$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user as u ON o.fk_user = u.rowid';

	// 	$sql .= ' WHERE 1 ';

	// 	if($month > 0) {
	// 		$sql .= ' AND o.month = '.$month;
	// 	}
	// 	$sql .= ' AND o.qz = '.$qz;
		
	// 	$sql .= ' AND o.year = '.$year;

	// 	$sql .= $fk_user>0 ? ' AND o.fk_user='.$fk_user : '';
	// 	$sql .= !empty($srch_job) ? " AND u.job = '".$srch_job."'" : "";

	// 	$sql .= " AND u.employee = 1";

	// 	if($srch_group > 0) {
	// 		$sql .= " AND u.rowid IN (SELECT fk_user FROM ".MAIN_DB_PREFIX."usergroup_user WHERE fk_usergroup = ".(int)$srch_group." )";
	// 	}

	// 	$sql .= " ORDER BY u.job ASC";

    // 	$resql = $this->db->query($sql);
    // 	if($resql){

    // 		$numrows = $this->db->num_rows($resql);

    // 		if($numrows > 0) {
	//     		while ($obj = $this->db->fetch_object($resql)) {
	//     			// $date = $this->db->jdate($obj->datep);

	//     			$data[$obj->fk_user]['id']		= $obj->rowid;
	//     			$data[$obj->fk_user]['tjm']		= $obj->tjm ? $obj->tjm : $obj->user_tjm;
	//     			$data[$obj->fk_user]['qz']		= $obj->qz;
	//     			$data[$obj->fk_user]['month']	= $obj->month;
	//     			$data[$obj->fk_user]['year']	= $obj->year;

	//     		}
    // 		} else {
    // 			// $lastmonth
    // 			// $data = $this->pointagerh_datamonth($month, $year, $fk_user = '', $srch_job = '', $srch_group = 0)
    // 		}
    // 	}
    // 	return $data;
    // }

} 
	

	
?>