<?php

global $parcmaterielenabled;


if($modaction == 'include') {
	require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
	require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
	require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';

	$parcmaterielenabled = false;

	if(!empty($conf->parcmateriel->enabled)) {
		// accessforbidden($langs->trans('DependsOn').' : '.$langs->trans('parcmateriel'));
		$parcmaterielenabled = true;
	}

	dol_include_once('/pointagerh/class/pointagerh.class.php');
	dol_include_once('/pointagerh/class/pointagerh_pointage.class.php');

	if($parcmaterielenabled)
		dol_include_once('/parcmateriel/class/parcmateriel_chantier.class.php');

	$langs->load('pointagerh@pointagerh');
	$langs->load('products');
	$langs->load('other');
	$langs->load('admin');
	$langs->load('errors');


	$usercanread    = $user->rights->pointagerh->lire;
	$usercanreadall = $user->rights->pointagerh->all->lire;
	$usercaneditall = $user->rights->pointagerh->creer;

	if(!$conf->global->POINTAGERH_SHOW_LEFTMENU)
		$conf->dol_hide_leftmenu = 1;

	$nbh_day_fixe = $conf->global->POINTAGERH_NBHBYDAY ? $conf->global->POINTAGERH_NBHBYDAY : 9;
	$nbd_month_fixe = $conf->global->POINTAGERH_NBDBYMONTH ? $conf->global->POINTAGERH_NBDBYMONTH : 26;

}
elseif($modaction == 'initial_obj') {
	
	$form       = new Form($db);
	$formother  = new FormOther($db);
	$userstatic = new User($db);
	$pointagerh = new pointagerh($db);
	$object     = new pointagerh_pointage($db);
	$group      = new UserGroup($db);

	$defaultchantier = 0;
	if($parcmaterielenabled) {
		$chantier 	= new parcmateriel_chantier($db);
		// ----------------------------------------------------------------------------------------------------------------------
		$defaultchantier = (isset($user->conf->POINTAGERH_LAST_SELECTED_CHANTIER) && ($user->conf->POINTAGERH_LAST_SELECTED_CHANTIER > 0)) ? $user->conf->POINTAGERH_LAST_SELECTED_CHANTIER : ($showoredit == 'edit' ? $pointagerh->getLastInsertedChantier() : 0);
	}


	if(GETPOST('srch_chantier', 'int') > 0) {
		$resusrs = dol_set_user_param($db, $conf, $user, ['POINTAGERH_LAST_SELECTED_CHANTIER' => GETPOST('srch_chantier', 'int')]);
	}
	// ----------------------------------------------------------------------------------------------------------------------

	$newToken 	 = isset($_SESSION['newtoken']) ? $_SESSION['newtoken'] : '';
	$mode   	 = GETPOST('mode') ? GETPOST('mode') : 'month';
	$sortfield   = GETPOST('sortfield') ? GETPOST('sortfield') : "o.rowid";
	$sortorder   = GETPOST('sortorder') ? GETPOST('sortorder') : "ASC";
	$id          = GETPOST('id');
	$action      = GETPOST('action');
	$toselect    = GETPOST('toselect', 'array');

	$year        = GETPOST('year', 'int') ? GETPOST('year', 'int') : date('Y');
	$fk_user     = GETPOST('fk_user', 'int');

	$showmonthsoneuser = ($showoredit == 'show' && $fk_user > 0 && GETPOST('month', 'int') == 0) ? true : false;

	$month       = (int) GETPOST('month', 'int') > 0 ? GETPOST('month', 'int') : ($showmonthsoneuser ? -1 : date('m'));
	$srch_job    = GETPOST('srch_job');
	$srch_group  = GETPOST('srch_group', 'int') > 0 ? GETPOST('srch_group', 'int') : 0;
	$quinzaine   = GETPOST('quinzaine') ? GETPOST('quinzaine') : (((int) date('d') > 15) ? 'second' : 'first');

	$srch_chantier  = GETPOST('srch_chantier', 'int') > 0 ? GETPOST('srch_chantier', 'int') : (GETPOST('srch_chantier', 'int') != -1 ? $defaultchantier : GETPOST('srch_chantier', 'int'));
	// ----------------------------------------------------------------------------------------------------------------------

	// if(GETPOST('button_removefilter_x')){
	//     $fk_user = '';
	//     $srch_job = '';
	//     $srch_group = '';
	// }
	
	// ----------------------------------------------------------------------------------------------------------------------

	$fk_user = $usercanreadall ? $fk_user : $user->id;

	$limit  = GETPOST('limit') ? GETPOST('limit') : $conf->liste_limit;
	$page   = GETPOST("page",'int');
	$page = is_numeric($page) ? $page : 0;
	$page = $page == -1 ? 0 : $page;
	$offset = $limit * $page;
	$pageprev = $page - 1;
	$pagenext = $page + 1;

	$param = $fk_user>0 ? '&fk_user='.$fk_user : '';
	$param .= !empty($limit) ? '&limit='.urlencode($limit) : '';
	$param .= (!empty($fk_employe)) ? '&fk_employe='.urlencode($fk_employe) : '';
	$param .= (!empty($month)) ? '&month='.urlencode($month) : '';
	$param .= (!empty($year)) ? '&year='.urlencode($year) : '';
	$param .= !empty($srch_job) ? '&srch_job='.urlencode($srch_job) : '';
	$param .= ($srch_group > 0) ? '&srch_group='.urlencode($srch_group) : '';
	$param .= '&mode='.urlencode($mode);
	$param .= $srch_chantier > 0 ? '&srch_chantier='.urlencode($srch_chantier) : '';
	$param .= ($quinzaine) ? '&quinzaine='.urlencode($quinzaine) : '';

	$nb_day = 1;
	$firstdaymonth = 1;
	$lastdaymonth = 1;

	if($month > 0) {
		$start = dol_mktime(0, 0, 0, $month, 1, $year);
		$end = dol_get_last_day($year, $month);

		$dd = dol_getdate($end);
		$nb_day = $dd['mday'];

		$firstdaymonth = ($mode == 'qz') ? (($quinzaine == 'second') ? 16 : 1) : 1;
		$lastdaymonth = ($mode == 'qz') ? (($quinzaine == 'second') ? $nb_day : 15) : $nb_day;
	}

	$lastyear = 0;
	$lastmonth = 0;


}
 
elseif($modaction == 'sql_actions') {
	$sql = 'SELECT o.* ';

	$sql .= ', u.login, u.lastname, u.firstname, u.email as user_email, u.statut as user_statut, u.entity, u.photo, u.office_phone, u.office_fax, u.user_mobile, u.job, u.gender';

	$sql .= ' FROM '.MAIN_DB_PREFIX.'pointagerh_datamonth as o';
	$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user as u ON (u.rowid = o.fk_user)';
	$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user_extrafields as exu ON (u.rowid = exu.fk_object)';

	if($parcmaterielenabled)
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'parcmateriel_chantier as ch ON (ch.rowid = o.fk_chantier)';

	$sql .= ' WHERE 1 ';

	$sql .= $fk_user>0 ? ' AND u.rowid='.$fk_user : '';

	$sql .= !empty($srch_job) ? " AND u.job = '".$srch_job."'" : "";

	$sql .= " AND u.employee = 1";

	if($srch_group > 0) {
	    $sql .= " AND u.rowid IN (SELECT fk_user FROM ".MAIN_DB_PREFIX."usergroup_user WHERE fk_usergroup = ".(int)$srch_group." )";
	}

	if($mode) {
		$sql .= ' AND exu.pointagerh_pointagetype = "'.$mode.'"';
	}

	if($parcmaterielenabled && $srch_chantier > 0) {
		$sql .= ' AND o.fk_chantier = "'.$srch_chantier.'"';
	}

	if($month > 0) {
		$sql .= ' AND o.month = '.(int) $month;
	}
	$sql .= ' AND o.year = '.(int) $year;


	$sql .= ' GROUP BY u.rowid';

	// echo $sql;

	$sql .= $db->order($sortfield, $sortorder);
	// Count total nb of records with no order and no limits
	$nbtotalofrecords = '';
	if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST) || 1>0) {
	    $resql = $db->query($sql);
	    if ($resql) {
	        $nbtotalofrecords = $db->num_rows($resql);
	    } else {
	        dol_print_error($db);
	    }
	    if (($page * $limit) > $nbtotalofrecords) { // if total resultset is smaller then paging size (filtering), goto and load page 0
	        $page = 0;
	        $offset = 0;
	    }
	}
	// echo $sql;

	// Add limit
	// $sql .= $db->plimit($limit + 1, $offset);
	$resqobj = $db->query($sql);
	$num = $resqobj ? $db->num_rows($resqobj) : 0;

	$totpointlastmonth = 0;

	if($num > 0) {
		$datapointage = $object->dataPointage($month, $year, $srch_chantier, $fk_user, $srch_job, $srch_group);

	} else {

		if($month > 0) {
			$sql2 = "SELECT COUNT(o.rowid) as total_pointage ";
			$sql2 .= " FROM ".MAIN_DB_PREFIX."pointagerh_datamonth as o";

			$sql2 .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user as u ON (u.rowid = o.fk_user)';
			$sql2 .= ' LEFT JOIN '.MAIN_DB_PREFIX.'user_extrafields as exu ON (u.rowid = exu.fk_object)';
			
			$sql2 .= " WHERE 1";

			$srchperiod = $year.'-'.sprintf("%02d", $month).'-01';

			$lastyear = date('Y', strtotime("-1 months", strtotime($srchperiod)));
			$lastmonth = date('m', strtotime("-1 months", strtotime($srchperiod)));

			$sql2 .= " AND o.month = ".(int) $lastmonth;
			$sql2 .= " AND o.year = ".(int) $lastyear;

			$sql2 .= ' AND exu.pointagerh_pointagetype = "'.$mode.'"';

			$resql2 = $db->query($sql2);

			if ($resql2) {
				$obj = $db->fetch_object($resql2);
				$totpointlastmonth = (int) $obj->total_pointage;
			}
		}
	}

	// d($datapointage);
	if($mode == 'qz') {
		// $datamonth = $object->pointagerh_datamonth($month, $year, $fk_user, $srch_job, $srch_group);
	}

	// d($datap);

	$title = $langs->trans("pointagerh_pointage");

	// $titlemode = (($mode == 'qz') ? $langs->trans('pointagerhByQZ') : $langs->trans('pointagerhByMonth'));
    // $title .= ' ';
    // $title .= strtolower($titlemode);

	if($month > 0){
	    $title .= ' > ' .$langs->trans("Month".sprintf("%02d", $month))." ".$year;
	}else{
	    $title .= ' > ' .$year;
	}

	if($mode == 'qz') {
		$title .= ' > '. (($quinzaine == 'second') ? $langs->trans('SecondHalfOfMonth') : $langs->trans('FirstHalfOfMonth'));
	}

	if($parcmaterielenabled && $srch_chantier > 0) {
		$chantier->fetch($srch_chantier);
		$title .= ' - <b>'.$chantier->label.'</b>';
	}

	$tdtitle ='';

	/*-------------excel-----------------*/
	if ($action == 'export_xls') {
	    
	    $filename = html_entity_decode($langs->trans('pointagerh').'_'.sprintf('%02d', $month).'-'.$year).".xls";
	    require_once dol_buildpath('/pointagerh/tpl/etat.tpl.php');

	    header("Content-Type: application/xls");
	    header("Content-Disposition: attachment; filename=".$filename);
	    echo $html;
	    die(); 

	}

	$pdfFont = isset($conf->global->MAIN_PDF_FORCE_FONT) ? $conf->global->MAIN_PDF_FORCE_FONT : 'helvetica';

	/*-------------Pdf-----------------*/
	if($action == 'export_pdf'){

	    global $langs,$mysoc;
	    require_once dol_buildpath('/pointagerh/pdf/pdf.lib.php');

	    $pdf->SetMargins(7, 2, 7, false);
	    $pdf->SetFooterMargin(10);
	    $pdf->setPrintFooter(true);
	    $pdf->SetAutoPageBreak(TRUE,15);

	    $array_format = pdf_getFormat();

	    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
	    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
	    $margin = $marge_haute+$marge_basse+45;

	    $page_largeur = $formatarray['width'];
	    $page_hauteur = $formatarray['height'];
	    $format = array($page_largeur,$page_hauteur);

	    $marge_gauche=isset($conf->global->MAIN_PDF_MARGIN_LEFT)?$conf->global->MAIN_PDF_MARGIN_LEFT:10;
	    $marge_droite=isset($conf->global->MAIN_PDF_MARGIN_RIGHT)?$conf->global->MAIN_PDF_MARGIN_RIGHT:10;
	    $marge_haute =isset($conf->global->MAIN_PDF_MARGIN_TOP)?$conf->global->MAIN_PDF_MARGIN_TOP:10;
	    $marge_basse =isset($conf->global->MAIN_PDF_MARGIN_BOTTOM)?$conf->global->MAIN_PDF_MARGIN_BOTTOM:10;
	    $emetteur = $mysoc;

	    $default_font_size = pdf_getPDFFontSize($langs);

	    $pdf->AddPage('L');

	    pdf_pagehead($pdf,$langs,$page_hauteur);

	    $pdf->SetTextColor(0,0,60);
	    $pdf->SetFont($pdfFont,'B', $default_font_size + 2);

	    $posy = $marge_haute;
	    $posx = $page_largeur-$marge_droite-100;

	    $pdf->SetXY($marge_gauche,$posy);
	    
	    // $pdf->setRTL(true);

	    // Logo
	    $logo=$conf->mycompany->dir_output.'/logos/'.$emetteur->logo;

	    $topheader = 25;
	    if ($emetteur->logo)
	    {
	        if (is_readable($logo))
	        {
	            $height=pdf_getHeightForLogo($logo);
	            $pdf->Image($logo, $marge_gauche, $posy, 0, $height); // width=0 (auto)
	            $topheader = $posy + $height;
	        }
	        else
	        {
	            $pdf->SetTextColor(200,0,0);
	            $pdf->SetFont($pdfFont,'B', $default_font_size - 2);
	            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorLogoFileNotFound",$logo), 0, 'L');
	            $pdf->MultiCell(100, 3, $langs->transnoentities("ErrorGoToGlobalSetup"), 0, 'L');
	        }
	    }
	    else
	    {
	        $text=$emetteur->name;
	        $pdf->MultiCell(40, 2, $langs->convToOutputCharset($text), 0, 'L');
	    }

	    $pdf->SetFont($pdfFont, 'B', $default_font_size);
	    $pdf->SetXY($posx,$posy);
	    $pdf->MultiCell(100, 3, date("d/m/Y"), '', 'R');

	    $posy = $topheader;
	    $posx = $marge_gauche+5;

	    $pdf->SetFont($pdfFont, '', $default_font_size-3);
	    $pdf->SetXY($posx,$posy);

	    // require template
	    $filename = $langs->trans('pointagerh').' '.$langs->trans('Month'.sprintf('%02d', $month)).' '.$year.".xls";
	    require_once dol_buildpath('/pointagerh/tpl/etat.tpl.php');
	    $posy=$pdf->getY();
	    $pdf->SetXY($posx,$posy);
	    $pdf->writeHTML($html, true, false, true, false, '');
	    ob_start();

	    $pdf->Output($filename.'.pdf', 'I');
	    die();
	}




	$moreheadjs = '';

	$morejs = array('includes/jquery/plugins/blockUI/jquery.blockUI.js', 'core/js/blockUI.js', '/pointagerh/js/pointagerh.js.php'); // Used by ecm/tpl/enabledfiletreeajax.tpl.pgp
	$morecss = array('/pointagerh/css/pointagerh.css'); // Used by ecm/tpl/enabledfiletreeajax.tpl.pgp
	$moreheadjs .= '<script type="text/javascript">'."\n";
	$moreheadjs .= 'var indicatorBlockUI = \''.DOL_URL_ROOT."/theme/".$conf->theme."/img/working.gif".'\';'."\n";
	$moreheadjs .= '$( document ).ready(function() {
	    $("input[type=submit], button[type=submit]").click( function() {
	        $.pleaseBePatient("'.$langs->trans('PleaseBePatient').'");
	    });
	});';
	$moreheadjs .= '</script>'."\n";

	$newcardbutton = '';
} 
elseif($modaction == 'showtitle' && $showoredit) {

	if(!$conf->global->POINTAGERH_SHOW_LEFTMENU) {
		?>
		<style>
			div.fiche {
			    margin-left: 12px;
			    margin-right: 12px;
			    margin-top: 6px;
			}
		</style>
		<?php
	}
	print_barre_liste($title, $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, $massactionbutton = '', $num, $nbtotalofrecords, $object->picto, 0, $newcardbutton, '', -1, 0, 0, 1);

    print '<div class="div-table-responsive width100p" style="min-height: auto;">';
        print '<table class="pointagerh_filter" width="100%">';
        print '<tr>';
        	if($usercanreadall) {
	            print '<td class="left select2js">';

	                ################################################################################################### Chantier
	            	if($parcmaterielenabled) {
		                print img_picto('', 'home').' ';
	                    print $pointagerh->pointagerh_select_chantier($srch_chantier, 'srch_chantier', ($showoredit == 'show' ? 1 : 0), '', 'width200 maxwidth200');
	            	}
	               
	                ################################################################################################### Group
	                // // print '<span>'.$langs->trans('Groups').': </span>';
	                // print '<span class="marginleftonly">';
	                // print img_picto('', 'group').' ';
	                // print $form->select_dolgroups($srch_group, 'srch_group', 1, 0, '', [], 0, '', false, 'width200 maxwidth200');
	                // print '</span>';


	                ################################################################################################### Poste
	                // print '<span class="marginleftonly">'.$langs->trans('PostOrFunction').': </span>';
	                // print '<br>';
	                print '<span class="marginleftonly">';
	                print img_picto('', 'contract').' ';
	                print $pointagerh->pointagerhSelectJobUsers($srch_job, $name = 'srch_job', $showempty = 1, $moreclass="width200 maxwidth200", $srch_group, $mode);
	                print '</span>';

	                
	                ################################################################################################### Employe
	                $morefilterusers = ($srch_job) ? " AND u.job = '".$srch_job."'" : '';
	                $morefilterusers .= " AND u.employee = 1";
	                $morefilterusers .= ' AND exu.pointagerh_pointagetype = "'.$mode.'"';
	                $users = [-1];
	                if($srch_group > 0) {
	                    $group->fetch($srch_group);
	                    $tmpusers = $group->listUsersForGroup('', 1);
	                    if($tmpusers) $users = $tmpusers;
	                } else {
	                    $users = [];
	                }
	                print '<span class="marginleftonly">';
	                print img_picto('', 'user').' ';
	                // print '<span class="marginleftonly">'.$langs->trans('Employe').': </span>';
	                print $pointagerh->pointagerh_select_dolusers($fk_user, 'fk_user', 1, $_exclude = null, $_disabled = 0, $_include = $users,$_enableonly = [], 0, 0, 0, $morefilterusers, 0, '', 'minwidth200 maxwidth300');
	                print '</span>';
	                // print '<button type="submit" class="liste_titre button_removefilter reposition" name="button_removefilter_x" value="x"><span class="fa fa-remove"></span></button>';

	            print '</td>';
        	}

            print '<td class="left width300 select2js">';
                print $langs->trans('Period').': ';
                print $formother->select_year($year, 'year', $_useempty = 0, $_min_year = 10, $_max_year = 0, $_offset = 0, $_invert = 0, $_option = '', $_morecss = 'minwidth75');

                $emptyvalue = ($showoredit == 'show' && $fk_user > 0) ? 1 : 0;

            	print ' '.$formother->select_month($month, 'month', $emptyvalue, 1, 'minwidth75');

            	if($mode == 'qz') {
            		$tmparr = array(
						'first' 	=> $langs->trans('FirstHalfOfMonth'),
						'second' 	=> $langs->trans('SecondHalfOfMonth')
					);

			        print ' '.$form->selectarray('quinzaine', $tmparr, $quinzaine, 0, 0, 0, $__moreparam='', 0, 0, 0, '', 'maxwidth200', 1);
            	}

            print '</td>';
            print '<td class="right">';
            	if($showoredit == 'show') {
            		if($usercaneditall)
                		print '<a href="insert.php?list=1'.$param.'" class="butAction badge-status4" >'.$langs->trans('Modify').'</a>';
            	} else {
            		print '<input type="submit" name="save" class="butAction badge-status4" value="'.$langs->trans('Save').'">';
                	print '<a href="index.php?list=1'.$param.'" class="butAction" >'.$langs->trans('Consulter').'</a>';
            	}
            print '</td>';
        print '</tr>';
        print '</table>';
    print '</div>';

    print '<br>';

    $tdtitle ='';

}