<?php
/* Copyright (C) 2019 Garcia MICHEL <garcia@soamichel.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

header('Content-Type: application/javascript');

if (file_exists('../../main.inc.php')) {
    @include '../../main.inc.php';
} elseif (file_exists('../../../main.inc.php')) {
    @include '../../../main.inc.php';
} else {
    header('HTTP/1.0 500 Internal Server Error ');
    print "// Include of main fails";
    exit();
}

require_once DOL_DOCUMENT_ROOT.'/holiday/class/holiday.class.php';

if ($langs->defaultlang == 'fr_FR') {
    $locale = 'fr';
} else {
    $locale = 'en';
}

$holiday = new Holiday($db);

$langs->load('holiday');
?>

$(function(){
    var $status = $(
        '<label style="background-color: <?php echo $conf->global->SOH_HOLIDAY_STATUS_1; ?>;">' +
            '<input type="checkbox" name="status[]" value="1"> <?php echo dol_escape_js($holiday->LibStatut(1)); ?>' +
        '</label>' +
        '<label style="background-color: <?php echo $conf->global->SOH_HOLIDAY_STATUS_2; ?>;">' +
            '<input type="checkbox" name="status[]" value="2" checked> <?php echo dol_escape_js($holiday->LibStatut(2)); ?>' +
        '</label>' +
        '<label style="background-color: <?php echo $conf->global->SOH_HOLIDAY_STATUS_3; ?>;">' +
            '<input type="checkbox" name="status[]" value="3" checked> <?php echo dol_escape_js($holiday->LibStatut(3)); ?>' +
        '</label>' +
        '<label style="background-color: <?php echo $conf->global->SOH_HOLIDAY_STATUS_4; ?>;">' +
            '<input type="checkbox" name="status[]" value="4"> <?php echo dol_escape_js($holiday->LibStatut(4)); ?>' +
        '</label>' +
        '<label style="background-color: <?php echo $conf->global->SOH_HOLIDAY_STATUS_5; ?>;">' +
            '<input type="checkbox" name="status[]" value="5"> <?php echo dol_escape_js($holiday->LibStatut(5)); ?>' +
        '</label>'
    );

    $('#calendar').fullCalendar({
        locale: '<?php echo $locale; ?>',
        header: {
            left: 'title',
            center: '',
            right: 'today prev,next'
        },
        events: {
            url: '<?php echo dol_buildpath('/soh/list.json.php', 1); ?>',
            data: function() {
                var selectedStatus = [];
                $status.find('input[name="status[]"]').each(function() {
                    if (this.checked) {
                        selectedStatus.push(this.value);
                    }
                });

                return {selectedStatus: selectedStatus};
            }
        },
        displayEventTime: false,
        eventClick: function(event, jsEvent, view) {
            window.open(event.url, '_blank' );
            return false;
        }
    });

    $status.appendTo('.fc-center');
    $status.find('input[name="status[]"]').change(function() {
        $('#calendar').fullCalendar('refetchEvents');
    });
});
