<?php
/* Copyright (C) 2019 Garcia MICHEL <garcia@soamichel.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

header('Content-Type: application/json');

if (file_exists('../main.inc.php')) {
    @include '../main.inc.php';
} elseif (file_exists('../../main.inc.php')) {
    @include '../../main.inc.php';
} else {
    header('HTTP/1.0 500 Internal Server Error ');
    print "// Include of main fails";
    exit();
}

require_once DOL_DOCUMENT_ROOT.'/holiday/class/holiday.class.php';

$langs->load('holiday');

$start = GETPOST('start');
$end = GETPOST('end');
$selectedStatus = GETPOST('selectedStatus', 'array');

$holiday = new Holiday($db);
$filter = " AND ((cp.date_debut BETWEEN '".$start." 00:00:00' AND '".$end." 23:59:59')";
$filter.= " OR (cp.date_fin BETWEEN '".$start." 00:00:00' AND '".$end." 23:59:59')";
$filter.= " OR (cp.date_debut <= '".$start." 00:00:00' AND cp.date_fin >= '".$end." 23:59:59'))"; // pour inclure les demandes commencants avant le mois et terminant après
$filter.= " AND cp.statut IN (".implode(',', $selectedStatus).")";

if (
    (version_compare(DOL_VERSION, '11.0.0') > 0 and $user->rights->holiday->readall) or
    $user->rights->holiday->read_all // for Dolibarr 11.0.0 and before
) {
    $res = $holiday->fetchAll('', $filter);
} else {
    $childids = $user->getAllChildIds(1);
    $res = $holiday->fetchByUser(implode(',', $childids), '', $filter);
}

if ($res <= 0) {
    header('HTTP/1.0 500 Internal Server Error ');
    print json_encode(array(
    'error' => $holiday->error
  ));
    exit;
}

$list = array();
$userRequest = new User($db);
$types = $holiday->getTypes();

foreach ($holiday->holiday as $infos) {
    $userRequest->id = $infos['fk_user'];
    $userRequest->firstname = $infos['user_firstname'];
    $userRequest->lastname = $infos['user_lastname'];
    $userRequest->login = $infos['user_login'];
    $userRequest->statut = $infos['user_statut'];
    $userRequest->photo = $infos['user_photo'];

    $title = $userRequest->getFullname($langs);
    if (isset($types[$infos['fk_type']])) {
        $title .= ' ('.$langs->transnoentitiesnoconv($types[$infos['fk_type']]['code']).')';
    }

    $holidayStart = dol_print_date($infos['date_debut'], '%Y-%m-%d');
    $holidayStart.= ' '.(in_array($infos['halfday'], array(0, 1)) ? $conf->global->SOH_MORNING_START : $conf->global->SOH_AFTERNOON_START);

    $holidayEnd = dol_print_date($infos['date_fin'], '%Y-%m-%d');
    $holidayEnd.= ' '.(in_array($infos['halfday'], array(0, -1)) ? $conf->global->SOH_AFTERNOON_END : $conf->global->SOH_MORNING_END);

    $statusColor = 'SOH_HOLIDAY_STATUS_'.$infos['statut'];

    $list[] = array(
    'title' => $title,
    'start' => $holidayStart,
    'end' => $holidayEnd,
    'url' => DOL_URL_ROOT.'/holiday/card.php?id='.$infos['rowid'],
    'color' => $conf->global->{$statusColor},
  );
}

print json_encode($list);
